﻿<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<%@ import Namespace="Soneta.Deklaracje.ZUS" %>
<%@ import Namespace="System.Diagnostics" %>
<%@ import Namespace="System.ComponentModel" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Kalend" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<TITLE>Zestawienie IWA</TITLE>
		<META content="C#" name="CODE_LANGUAGE">
		<META content="JavaScript" name="vs_defaultClientScript">
		<META content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
        <script runat="server">
                    
            void OnContextLoad(object sender, EventArgs e) {
                IWA iwa = (IWA)dc[typeof(IWA)];

                ReportHeader1["ROK"] = iwa.Rok.ToString();                
                
                int[] osobyWMies = new int[13];
                LiczOsoby(iwa, ref osobyWMies);

                int suma = 0, osoby = 0, miesiace = 0;
                LiczSume(ref osobyWMies, ref suma, ref osoby, ref miesiace);
                
                Soneta.Web.DataLabel[] dl = new Soneta.Web.DataLabel[] { dlM1, dlM2, dlM3, dlM4, dlM5, dlM6, dlM7, dlM8, dlM9, dlM10, dlM11, dlM12 };
                for (int i = 1; i <= 12; i++)
                    dl[i - 1].EditValue = osobyWMies[i];
                dlMS.EditValue = suma;
                
                dlUbezp.EditValue = suma;
                dlMies.EditValue = miesiace;
                dlSrednia.EditValue = osoby != 0 ? osoby.ToString() : "";
            }

            void LiczOsoby(IWA iwa, ref int[] osobyWMies) {
                SubTable pracownicy = KadryModule.GetInstance(dc).Pracownicy.WgKodu;
                if (iwa.Wydział != null)
                    pracownicy = pracownicy[new FieldCondition.In("Wydzial", iwa.Wydział.WydziałyZUS.ToArray())];

                FromTo rok = FromTo.Year(iwa.Rok);
                int m = pracownicy.Count;
                foreach (Pracownik p in pracownicy) {
                    if (p is PracownikFirmy) { }
                    else if (p is Wlasciciel) {
                        if (p.IndywidualnaDRA)
                            continue;
                    }
                    else if (p is OsobaWspolpracujaca) {
                        if (p.Wlasciciel != null && p.Wlasciciel.IndywidualnaDRA)
                            continue;
                    }

                    Periods okresy = Periods.Empty;
                    //Wyliczamy okresy podlegania ubezpieczeniu
                    foreach (PracHistoria ph in p.Historia.GetIntersectedRows(rok))
                        okresy += ph.Etat.Ubezpieczenia.Wypadkowe.Okres * ph.Etat.EfektywnyOkres;

                    foreach (Umowa umowa in p.Umowy)
                        if (!umowa.Anulowana)
                            foreach (UmowaHistoria uh in umowa.Historia)
                                okresy += uh.Ubezpieczenia.Wypadkowe.Okres * uh.EfektywnyOkres;

                    okresy *= rok;
                    okresy = okresy.ToFlat();

                    //Wycinamy okresy nieobecności
                    Periods okrNie = Periods.Empty;
                    foreach (INieobecnosc n in p.Czasy.KalkPracy.Nieobecnosci(rok, true))
                        switch (n.Definicja.Przyczyna) {
                            case PrzyczynaNieobecnosci.UrlopBezpłatny:
                            case PrzyczynaNieobecnosci.UrlopWychowawczy:
                            case PrzyczynaNieobecnosci.UrlopWychowawczyZUS:
                            case PrzyczynaNieobecnosci.UrlopMacierzyński:
                            case PrzyczynaNieobecnosci.UrlopRodzicielski:       //TID: 17913
                            case PrzyczynaNieobecnosci.UrlopOjcowski:           //TID: 18051
                            case PrzyczynaNieobecnosci.SłużbaWojskowa:
                                okrNie += n.Okres;
                                break;
                        }

                    okrNie = okrNie.ToFlat();
                    okresy -= okrNie;

                    //Tniemy na miesiące i dodajemy do tablicy
                    okresy = okresy.ToFlat().BreakByMonth();

                    int prev = 0;
                    foreach (FromTo okres in okresy) {
                        int month = okres.To.Month;
                        if (month != prev) {
                            prev = month;
                            osobyWMies[month]++;
                        }
                    }
                }
            }

            void LiczSume(ref int[] osobyWMies, ref int suma, ref int osoby, ref int miesiace) {
                //Wyliczamy sumę i średnią
                for (int i = 1; i <= 12; i++) {
                    int ilosc = osobyWMies[i];
                    suma += ilosc;
                    if (ilosc != 0) miesiace++;
                }
                if (miesiace == 12)
                    osoby = (int)Soneta.Tools.Math.Round(((decimal)suma) / 12);
            }
                   
		</script>
	</HEAD>
	<BODY>
		<FORM method="post" runat="server">
			<ea:DataContext id="dc" runat="server" oncontextload="OnContextLoad"></ea:DataContext>
            <eb:ReportHeader id="ReportHeader1" runat="server" title="Raport pomocniczy do deklaracji ZUS IWA|Za rok: %ROK%"></eb:ReportHeader>
				<P></P>
                <DIV style="FONT-WEIGHT: bold; FONT-SIZE: 8pt; WIDTH: 100%; BORDER-BOTTOM: thin solid; FONT-FAMILY: Verdana">
                    Dane o liczbie ubezpieczonych zgłoszonych do ubezpieczenia wypadkowego
				</DIV>
				<P>
					<TABLE id="Table1" style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana" cellSpacing="0" cellPadding="0" width="50%" border="1">
						<TR>
							<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana" align="left" width="40%"><b>Miesiąc</b></TD>
							<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana" align="left" width="60%"><b>Liczba ubezpieczonych</b> *</TD>
						</TR>
						<TR>
							<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana" align="left">styczeń</TD>
							<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana" align="center">
                                <ea:DataLabel id="dlM1" runat="server" Bold="false"></ea:DataLabel>
							</TD>
						</TR>
						<TR>
							<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana" align="left">luty</TD>
							<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana" align="center">
                                <ea:DataLabel id="dlM2" runat="server" Bold="false"></ea:DataLabel>
							</TD>
						</TR>
						<TR>
							<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana" align="left">marzec</TD>
							<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana" align="center">
                                <ea:DataLabel id="dlM3" runat="server" Bold="false"></ea:DataLabel>
							</TD>
						</TR>
						<TR>
							<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana" align="left">kwiecień</TD>
							<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana" align="center">
                                <ea:DataLabel id="dlM4" runat="server" Bold="false"></ea:DataLabel>
							</TD>
						</TR>
						<TR>
							<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana" align="left">maj</TD>
							<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana" align="center">
                                <ea:DataLabel id="dlM5" runat="server" Bold="false"></ea:DataLabel>
							</TD>
						</TR>
						<TR>
							<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana" align="left">czerwiec</TD>
							<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana" align="center">
                                <ea:DataLabel id="dlM6" runat="server" Bold="false"></ea:DataLabel>
							</TD>
						</TR>
						<TR>
							<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana" align="left">lipiec</TD>
							<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana" align="center">
                                <ea:DataLabel id="dlM7" runat="server" Bold="false"></ea:DataLabel>
							</TD>
						</TR>
						<TR>
							<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana" align="left">sierpień</TD>
							<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana" align="center">
                                <ea:DataLabel id="dlM8" runat="server" Bold="false"></ea:DataLabel>
							</TD>
						</TR>
						<TR>
							<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana" align="left">wrzesień</TD>
							<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana" align="center">
                                <ea:DataLabel id="dlM9" runat="server" Bold="false"></ea:DataLabel>
							</TD>
						</TR>
						<TR>
							<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana" align="left">październik</TD>
							<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana" align="center">
                                <ea:DataLabel id="dlM10" runat="server" Bold="false"></ea:DataLabel>
							</TD>
						</TR>
						<TR>
							<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana" align="left">listopad</TD>
							<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana" align="center">
                                <ea:DataLabel id="dlM11" runat="server" Bold="false"></ea:DataLabel>
							</TD>
						</TR>
						<TR>
							<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana" align="left">grudzień</TD>
							<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana" align="center">
                                <ea:DataLabel id="dlM12" runat="server" Bold="false"></ea:DataLabel>
							</TD>
						</TR>
						<TR>
							<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana" align="left"><b>RAZEM</b></TD>
							<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana" align="center">
                                <ea:DataLabel id="dlMS" runat="server" Bold="false"></ea:DataLabel>
							</TD>
						</TR>
					</TABLE>
				</P>
				<P>
					<TABLE id="Table2" style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana" cellSpacing="0" cellPadding="0" width="70%" border="1">
						<TR>
							<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana" align="left" width="30%"><b>Liczba<br />ubezpieczonych w roku</b></TD>
							<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana" align="left" width="30%"><b>Ilość miesięcy</b></TD>
							<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana" align="left" width="40%"><b>Średnia miesięczna liczba ubezpieczonych</b> **</TD>
						</TR>
						<TR>
							<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana" align="center">
                                <ea:DataLabel id="dlUbezp" runat="server" Bold="false"></ea:DataLabel>
							</TD>
							<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana" align="center">
                                <ea:DataLabel id="dlMies" runat="server" Bold="false"></ea:DataLabel>
							</TD>
							<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana" align="center">
                                <ea:DataLabel id="dlSrednia" runat="server" Bold="false"></ea:DataLabel>
							</TD>
						</TR>
					</TABLE>
				</P>
                <P>&nbsp;</P><P>&nbsp;</P><P>&nbsp;</P><P>&nbsp;</P><P>&nbsp;</P><P>&nbsp;</P><P>&nbsp;</P><P>&nbsp;</P><P>&nbsp;</P><P>&nbsp;</P><P>&nbsp;</P><P>&nbsp;</P><P>&nbsp;</P><P>&nbsp;</P>
                <DIV style="FONT-WEIGHT: normal; FONT-SIZE: 6pt; WIDTH: 100%; FONT-FAMILY: Verdana">
                    * W liczbie ubezpieczonych nie są uwzględniani pracownicy przebywający pełny miesiąc na urlopach : bezpłatnym, macierzyńskim, wychowawczym i odbywający służbę wojskową.
				</DIV>
                <DIV style="FONT-WEIGHT: normal; FONT-SIZE: 6pt; WIDTH: 100%; FONT-FAMILY: Verdana">
                    ** Średnia miesięczna liczba ubezpieczonych wyliczana jest w przypadku, jeżeli w każdym z 12 miesięcy jest przynajmniej jeden ubezpieczony podlegający ubezpieczeniu wypadkowemu.
                </DIV>
                <P></P>
            <eb:ReportFooter id="ReportFooter1" runat="server"></eb:ReportFooter>
		</FORM>
	</BODY>
</HTML>
